/*
 * Decompiled with CFR 0.152.
 */
package me.alphamode.star.client.models;

import java.util.function.Supplier;
import me.alphamode.star.client.models.FluidBakedModel;
import me.alphamode.star.client.renderers.UpsideDownFluidRenderer;
import me.alphamode.star.world.fluids.DirectionalFluid;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1058;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_5431;
import net.minecraft.class_5819;

public class UpsideDownFluidModel
implements FluidBakedModel {
    private static final float EPSILON = 0.0f;

    public static boolean isSideExposed(class_1920 world, int x, int y, int z, class_2350 dir, float height) {
        class_2338 pos = new class_2338(x + dir.method_10148(), y + dir.method_10164(), z + dir.method_10165());
        class_2680 blockState = world.method_8320(pos);
        if (blockState.method_26225()) {
            class_265 shape = blockState.method_26201((class_1922)world, pos);
            if (shape == class_259.method_1077()) {
                return dir == class_2350.field_11036;
            }
            if (shape.method_1110()) {
                return true;
            }
            class_265 threshold = class_259.method_1081((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)height, (double)1.0);
            return !class_259.method_1083((class_265)threshold, (class_265)shape, (class_2350)dir);
        }
        return true;
    }

    public static boolean isFluidOccluded(class_1920 world, int x, int y, int z, class_2350 dir, class_3611 fluid) {
        class_2338 pos = new class_2338(x, y, z);
        class_2680 blockState = world.method_8320(pos);
        class_2338 adjPos = new class_2338(x + dir.method_10148(), y + dir.method_10164(), z + dir.method_10165());
        if (!blockState.method_26225()) {
            return world.method_8316(adjPos).method_15772().method_15780(fluid);
        }
        return world.method_8316(adjPos).method_15772().method_15780(fluid) || blockState.method_30368((class_1922)world, pos, dir, class_5431.field_25822);
    }

    @Override
    public void emitFluidQuads(class_1920 world, class_2680 state, class_3610 fluidState, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        float yOffset;
        float h4;
        float h3;
        float h2;
        float h1;
        int posX = pos.method_10263();
        int posY = pos.method_10264();
        int posZ = pos.method_10260();
        DirectionalFluid fluid = (DirectionalFluid)fluidState.method_15772();
        FluidRenderHandler handler = FluidRenderHandlerRegistry.INSTANCE.get((class_3611)fluid);
        int fluidColor = handler.getFluidColor(world, pos, fluidState);
        boolean sfUp = UpsideDownFluidModel.isFluidOccluded(world, posX, posY, posZ, fluid.getFlowDirection().method_10153(), (class_3611)fluid);
        boolean sfDown = UpsideDownFluidModel.isFluidOccluded(world, posX, posY, posZ, fluid.getFlowDirection(), (class_3611)fluid) || !UpsideDownFluidModel.isSideExposed(world, posX, posY, posZ, fluid.getFlowDirection(), 0.8888889f);
        boolean sfNorth = UpsideDownFluidModel.isFluidOccluded(world, posX, posY, posZ, class_2350.field_11043, (class_3611)fluid);
        boolean sfSouth = UpsideDownFluidModel.isFluidOccluded(world, posX, posY, posZ, class_2350.field_11035, (class_3611)fluid);
        boolean sfWest = UpsideDownFluidModel.isFluidOccluded(world, posX, posY, posZ, class_2350.field_11039, (class_3611)fluid);
        boolean sfEast = UpsideDownFluidModel.isFluidOccluded(world, posX, posY, posZ, class_2350.field_11034, (class_3611)fluid);
        if (sfUp && sfDown && sfEast && sfWest && sfNorth && sfSouth) {
            return;
        }
        class_1058[] sprites = handler.getFluidSprites(world, pos, fluidState);
        float fluidHeight = UpsideDownFluidRenderer.getFluidHeight(world, fluid, pos);
        if (fluidHeight >= 1.0f) {
            h1 = 1.0f;
            h2 = 1.0f;
            h3 = 1.0f;
            h4 = 1.0f;
        } else {
            float north1 = UpsideDownFluidRenderer.getFluidHeight(world, fluid, pos.method_10095());
            float south1 = UpsideDownFluidRenderer.getFluidHeight(world, fluid, pos.method_10072());
            float east1 = UpsideDownFluidRenderer.getFluidHeight(world, fluid, pos.method_10078());
            float west1 = UpsideDownFluidRenderer.getFluidHeight(world, fluid, pos.method_10067());
            h1 = UpsideDownFluidRenderer.getHeightToRenderFluid(world, fluid, fluidHeight, north1, west1, pos.method_10093(class_2350.field_11043).method_10093(class_2350.field_11039));
            h2 = UpsideDownFluidRenderer.getHeightToRenderFluid(world, fluid, fluidHeight, south1, west1, pos.method_10093(class_2350.field_11035).method_10093(class_2350.field_11039));
            h3 = UpsideDownFluidRenderer.getHeightToRenderFluid(world, fluid, fluidHeight, south1, east1, pos.method_10093(class_2350.field_11035).method_10093(class_2350.field_11034));
            h4 = UpsideDownFluidRenderer.getHeightToRenderFluid(world, fluid, fluidHeight, north1, east1, pos.method_10093(class_2350.field_11043).method_10093(class_2350.field_11034));
        }
        QuadEmitter quad = context.getEmitter();
        if (!sfUp && UpsideDownFluidModel.isSideExposed(world, posX, posY, posZ, fluid.getFlowDirection(), Math.min(Math.min(h1, h2), Math.min(h3, h4)))) {
            float v4;
            float u4;
            float v3;
            float u3;
            float v2;
            float u2;
            float v1;
            float u1;
            class_1058 sprite;
            h1 -= 0.0f;
            h2 -= 0.0f;
            h3 -= 0.0f;
            h4 -= 0.0f;
            class_243 velocity = fluidState.method_15758((class_1922)world, pos);
            if (velocity.field_1352 == 0.0 && velocity.field_1350 == 0.0) {
                sprite = sprites[0];
                u1 = sprite.method_4580(0.0);
                v1 = sprite.method_4570(0.0);
                u2 = u1;
                v2 = sprite.method_4570(16.0);
                u3 = sprite.method_4580(16.0);
                v3 = v2;
                u4 = u3;
                v4 = v1;
            } else {
                sprite = sprites[1];
                float dir = (float)class_3532.method_15349((double)velocity.field_1350, (double)velocity.field_1352) - 1.5707964f;
                float sin = class_3532.method_15374((float)dir) * 0.25f;
                float cos = class_3532.method_15362((float)dir) * 0.25f;
                u1 = sprite.method_4580((double)(8.0f + (-cos - sin) * 16.0f));
                v1 = sprite.method_4570((double)(8.0f + (-cos + sin) * 16.0f));
                u2 = sprite.method_4580((double)(8.0f + (-cos + sin) * 16.0f));
                v2 = sprite.method_4570((double)(8.0f + (cos + sin) * 16.0f));
                u3 = sprite.method_4580((double)(8.0f + (cos + sin) * 16.0f));
                v3 = sprite.method_4570((double)(8.0f + (cos - sin) * 16.0f));
                u4 = sprite.method_4580((double)(8.0f + (cos - sin) * 16.0f));
                v4 = sprite.method_4570((double)(8.0f + (-cos - sin) * 16.0f));
            }
            float uAvg = (u1 + u2 + u3 + u4) / 4.0f;
            float vAvg = (v1 + v2 + v3 + v4) / 4.0f;
            float s1 = (float)sprites[0].method_45851().method_45807() / (sprites[0].method_4577() - sprites[0].method_4594());
            float s2 = (float)sprites[0].method_45851().method_45815() / (sprites[0].method_4575() - sprites[0].method_4593());
            float s3 = 4.0f / Math.max(s2, s1);
            u1 = class_3532.method_16439((float)s3, (float)u1, (float)uAvg);
            u2 = class_3532.method_16439((float)s3, (float)u2, (float)uAvg);
            u3 = class_3532.method_16439((float)s3, (float)u3, (float)uAvg);
            u4 = class_3532.method_16439((float)s3, (float)u4, (float)uAvg);
            v1 = class_3532.method_16439((float)s3, (float)v1, (float)vAvg);
            v2 = class_3532.method_16439((float)s3, (float)v2, (float)vAvg);
            v3 = class_3532.method_16439((float)s3, (float)v3, (float)vAvg);
            v4 = class_3532.method_16439((float)s3, (float)v4, (float)vAvg);
            if (fluidState.method_15756((class_1922)world, pos.method_10084())) {
                quad.spriteBake(0, sprite, 32);
                this.setVertex(quad, 0, 0.0f, 1.0f - h1, 0.0f, u1, v1, fluid.getFlowDirection());
                this.setVertex(quad, 1, 0.0f, 1.0f - h2, 1.0f, u2, v2, fluid.getFlowDirection());
                this.setVertex(quad, 2, 1.0f, 1.0f - h3, 1.0f, u3, v3, fluid.getFlowDirection());
                this.setVertex(quad, 3, 1.0f, 1.0f - h4, 0.0f, u4, v4, fluid.getFlowDirection());
                quad.nominalFace();
                quad.spriteColor(0, fluidColor, fluidColor, fluidColor, fluidColor);
                quad.emit();
            }
            quad.spriteBake(0, sprite, 32);
            this.setVertex(quad, 0, 0.0f, 1.0f - h1, 0.0f, u1, v1, fluid.getFlowDirection().method_10153());
            this.setVertex(quad, 1, 1.0f, 1.0f - h4, 0.0f, u4, v4, fluid.getFlowDirection().method_10153());
            this.setVertex(quad, 2, 1.0f, 1.0f - h3, 1.0f, u3, v3, fluid.getFlowDirection().method_10153());
            this.setVertex(quad, 3, 0.0f, 1.0f - h2, 1.0f, u2, v2, fluid.getFlowDirection().method_10153());
            quad.spriteColor(0, fluidColor, fluidColor, fluidColor, fluidColor);
            quad.emit();
        }
        if (!sfDown) {
            yOffset = 1.0f;
            class_1058 sprite = sprites[0];
            float minU = sprite.method_4594();
            float maxU = sprite.method_4577();
            float minV = sprite.method_4593();
            float maxV = sprite.method_4575();
            quad.spriteBake(0, sprite, 32);
            this.setVertex(quad, 0, 1.0f, yOffset, 0.0f, minU, maxV, fluid.getFlowDirection());
            this.setVertex(quad, 1, 0.0f, yOffset, 0.0f, minU, minV, fluid.getFlowDirection());
            this.setVertex(quad, 2, 0.0f, yOffset, 1.0f, maxU, minV, fluid.getFlowDirection());
            this.setVertex(quad, 3, 1.0f, yOffset, 1.0f, maxU, maxV, fluid.getFlowDirection());
            quad.spriteColor(0, fluidColor, fluidColor, fluidColor, fluidColor);
            quad.emit();
        }
        yOffset = sfDown ? 0.0f : 0.0f;
        block5: for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_2338 adjPos;
            class_2680 adjBlock;
            float startZ;
            float endX;
            float startX;
            float endSideY;
            float sideY;
            float endZ = switch (direction) {
                case class_2350.field_11043 -> {
                    if (sfNorth) continue block5;
                    sideY = h1;
                    endSideY = h4;
                    startX = 0.0f;
                    endX = 1.0f;
                    startZ = 0.0f;
                    yield 0.0f;
                }
                case class_2350.field_11035 -> {
                    if (sfSouth) continue block5;
                    sideY = h3;
                    endSideY = h2;
                    startX = 1.0f;
                    endX = 0.0f;
                    startZ = 1.0f;
                    yield 1.0f;
                }
                case class_2350.field_11039 -> {
                    if (sfWest) continue block5;
                    sideY = h2;
                    endSideY = h1;
                    startX = 0.0f;
                    endX = 0.0f;
                    startZ = 1.0f;
                    yield 0.0f;
                }
                default -> {
                    if (sfEast) continue block5;
                    sideY = h4;
                    endSideY = h3;
                    startX = 1.0f;
                    endX = 1.0f;
                    startZ = 0.0f;
                    yield 1.0f;
                }
            };
            if (!UpsideDownFluidModel.isSideExposed(world, posX, posY, posZ, direction, Math.max(sideY, endSideY))) continue;
            class_1058 sprite = sprites[1];
            boolean isOverlay = false;
            if (sprites.length > 2 && FluidRenderHandlerRegistry.INSTANCE.isBlockTransparent((adjBlock = world.method_8320(adjPos = pos.method_10093(direction))).method_26204())) {
                sprite = sprites[2];
                isOverlay = true;
            }
            float startU = sprite.method_4580(0.0);
            float endV = sprite.method_4570((double)((1.0f - sideY) * 16.0f * 0.5f));
            float ap = sprite.method_4580(8.0);
            float ax = sprite.method_4570((double)((1.0f - endSideY) * 16.0f * 0.5f));
            float ay = sprite.method_4570(8.0);
            this.setVertex(quad, 0, endX, 1.0f - endSideY, endZ, ap, ax, direction);
            this.setVertex(quad, 1, startX, 1.0f - sideY, startZ, startU, endV, direction);
            this.setVertex(quad, 2, startX, 1.0f - yOffset, startZ, startU, ay, direction);
            this.setVertex(quad, 3, endX, 1.0f - yOffset, endZ, ap, ay, direction);
            quad.spriteColor(0, fluidColor, fluidColor, fluidColor, fluidColor);
            quad.emit();
            if (isOverlay) continue;
            this.setVertex(quad, 0, endX, 1.0f - yOffset, endZ, startU, ay, direction);
            this.setVertex(quad, 1, startX, 1.0f - yOffset, startZ, ap, ay, direction);
            this.setVertex(quad, 2, startX, 1.0f - sideY, startZ, ap, endV, direction);
            this.setVertex(quad, 3, endX, 1.0f - endSideY, endZ, startU, ax, direction);
            quad.spriteColor(0, fluidColor, fluidColor, fluidColor, fluidColor);
            quad.emit();
        }
    }

    public void setVertex(QuadEmitter emitter, int vertexIndex, float x, float y, float z, float u, float v, class_2350 normal) {
        emitter.pos(vertexIndex, x, y, z);
        emitter.sprite(vertexIndex, 0, u, v);
        emitter.nominalFace(normal);
    }
}

